<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once '../config/database.php';

$database = new Database();
$db = $database->getConnection();

// Get posted data
$data = json_decode(file_get_contents("php://input"));

if (!empty($data->invoice_ids) && !empty($data->status)) {
    
    try {
        $db->beginTransaction();
        
        // Validate status
        $valid_statuses = ['draft', 'sent', 'paid', 'cancelled'];
        if (!in_array($data->status, $valid_statuses)) {
            throw new Exception("Invalid status provided");
        }
        
        // Prepare update query
        $placeholders = str_repeat('?,', count($data->invoice_ids) - 1) . '?';
        $query = "UPDATE invoices SET status = ?, updated_at = CURRENT_TIMESTAMP WHERE id IN ($placeholders)";
        
        $stmt = $db->prepare($query);
        
        // Bind parameters
        $params = array_merge([$data->status], $data->invoice_ids);
        $stmt->execute($params);
        
        $affected_rows = $stmt->rowCount();
        
        $db->commit();
        
        http_response_code(200);
        echo json_encode(array(
            "success" => true,
            "message" => "Successfully updated $affected_rows invoice(s)",
            "affected_rows" => $affected_rows
        ));
        
    } catch (Exception $e) {
        $db->rollback();
        http_response_code(503);
        echo json_encode(array(
            "success" => false,
            "message" => "Error updating invoices: " . $e->getMessage()
        ));
    }
    
} else {
    http_response_code(400);
    echo json_encode(array(
        "success" => false,
        "message" => "Invoice IDs and status are required"
    ));
}
?>
