<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

include_once '../config/database.php';
include_once '../classes/Product.php';

$database = new Database();
$db = $database->getConnection();

$product = new Product($db);

if (isset($_GET['id'])) {
    $product->id = $_GET['id'];
    
    if ($product->readOne()) {
        http_response_code(200);
        echo json_encode(array(
            "success" => true,
            "product" => array(
                "id" => $product->id,
                "name" => $product->name,
                "description" => $product->description,
                "hsn_sac" => $product->hsn_sac,
                "unit" => $product->unit,
                "rate" => $product->rate,
                "tax_rate" => $product->tax_rate,
                "is_active" => $product->is_active
            )
        ));
    } else {
        http_response_code(404);
        echo json_encode(array(
            "success" => false,
            "message" => "Product not found."
        ));
    }
} else {
    http_response_code(400);
    echo json_encode(array(
        "success" => false,
        "message" => "Product ID is required."
    ));
}
?>
