<?php
require_once 'config/database.php';

class Customer {
    private $conn;
    private $table_name = "customers";

    public $id;
    public $name;
    public $billing_address;
    public $shipping_address;
    public $gstin;
    public $state;
    public $contact;
    public $email;

    public function __construct($db) {
        $this->conn = $db;
    }

    // Create customer
    public function create() {
        $query = "INSERT INTO " . $this->table_name . " 
                  SET name=:name, billing_address=:billing_address, shipping_address=:shipping_address,
                      gstin=:gstin, state=:state, contact=:contact, email=:email";

        $stmt = $this->conn->prepare($query);

        // Sanitize
        $this->name = htmlspecialchars(strip_tags($this->name));
        $this->billing_address = htmlspecialchars(strip_tags($this->billing_address));
        $this->shipping_address = htmlspecialchars(strip_tags($this->shipping_address));
        $this->gstin = htmlspecialchars(strip_tags($this->gstin));
        $this->state = htmlspecialchars(strip_tags($this->state));
        $this->contact = htmlspecialchars(strip_tags($this->contact));
        $this->email = htmlspecialchars(strip_tags($this->email));

        // Bind values
        $stmt->bindParam(":name", $this->name);
        $stmt->bindParam(":billing_address", $this->billing_address);
        $stmt->bindParam(":shipping_address", $this->shipping_address);
        $stmt->bindParam(":gstin", $this->gstin);
        $stmt->bindParam(":state", $this->state);
        $stmt->bindParam(":contact", $this->contact);
        $stmt->bindParam(":email", $this->email);

        if ($stmt->execute()) {
            return $this->conn->lastInsertId();
        }
        return false;
    }

    // Read all customers
    public function readAll() {
        $query = "SELECT * FROM " . $this->table_name . " ORDER BY name ASC";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }

    // Read single customer
    public function readOne() {
        $query = "SELECT * FROM " . $this->table_name . " WHERE id = ? LIMIT 0,1";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $this->id);
        $stmt->execute();

        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($row) {
            $this->name = $row['name'];
            $this->billing_address = $row['billing_address'];
            $this->shipping_address = $row['shipping_address'];
            $this->gstin = $row['gstin'];
            $this->state = $row['state'];
            $this->contact = $row['contact'];
            $this->email = $row['email'];
            return true;
        }
        return false;
    }

    // Update customer
    public function update() {
        $query = "UPDATE " . $this->table_name . "
                  SET name=:name, billing_address=:billing_address, shipping_address=:shipping_address,
                      gstin=:gstin, state=:state, contact=:contact, email=:email
                  WHERE id=:id";

        $stmt = $this->conn->prepare($query);

        $stmt->bindParam(':name', $this->name);
        $stmt->bindParam(':billing_address', $this->billing_address);
        $stmt->bindParam(':shipping_address', $this->shipping_address);
        $stmt->bindParam(':gstin', $this->gstin);
        $stmt->bindParam(':state', $this->state);
        $stmt->bindParam(':contact', $this->contact);
        $stmt->bindParam(':email', $this->email);
        $stmt->bindParam(':id', $this->id);

        return $stmt->execute();
    }

    // Delete customer
    public function delete() {
        $query = "DELETE FROM " . $this->table_name . " WHERE id = ?";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $this->id);
        return $stmt->execute();
    }

    // Search customers
    public function search($keywords) {
        $query = "SELECT * FROM " . $this->table_name . " 
                  WHERE name LIKE ? OR gstin LIKE ? OR contact LIKE ?
                  ORDER BY name ASC";

        $stmt = $this->conn->prepare($query);
        $keywords = "%{$keywords}%";
        $stmt->bindParam(1, $keywords);
        $stmt->bindParam(2, $keywords);
        $stmt->bindParam(3, $keywords);
        $stmt->execute();

        return $stmt;
    }
}
?>
