<?php
require_once 'config/database.php';

class Product {
    private $conn;
    private $table_name = "products";

    public $id;
    public $name;
    public $description;
    public $hsn_sac;
    public $unit;
    public $rate;
    public $tax_rate;
    public $is_active;

    public function __construct($db) {
        $this->conn = $db;
    }

    // Create product
    public function create() {
        $query = "INSERT INTO " . $this->table_name . " 
                  SET name=:name, description=:description, hsn_sac=:hsn_sac,
                      unit=:unit, rate=:rate, tax_rate=:tax_rate, is_active=:is_active";

        $stmt = $this->conn->prepare($query);

        // Sanitize
        $this->name = htmlspecialchars(strip_tags($this->name));
        $this->description = htmlspecialchars(strip_tags($this->description));
        $this->hsn_sac = htmlspecialchars(strip_tags($this->hsn_sac));
        $this->unit = htmlspecialchars(strip_tags($this->unit));

        // Bind values
        $stmt->bindParam(":name", $this->name);
        $stmt->bindParam(":description", $this->description);
        $stmt->bindParam(":hsn_sac", $this->hsn_sac);
        $stmt->bindParam(":unit", $this->unit);
        $stmt->bindParam(":rate", $this->rate);
        $stmt->bindParam(":tax_rate", $this->tax_rate);
        $stmt->bindParam(":is_active", $this->is_active);

        if ($stmt->execute()) {
            return $this->conn->lastInsertId();
        }
        return false;
    }

    // Read all active products
    public function readAll() {
        $query = "SELECT * FROM " . $this->table_name . " WHERE is_active = 1 ORDER BY name ASC";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }

    // Read single product
    public function readOne() {
        $query = "SELECT * FROM " . $this->table_name . " WHERE id = ? LIMIT 0,1";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $this->id);
        $stmt->execute();

        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($row) {
            $this->name = $row['name'];
            $this->description = $row['description'];
            $this->hsn_sac = $row['hsn_sac'];
            $this->unit = $row['unit'];
            $this->rate = $row['rate'];
            $this->tax_rate = $row['tax_rate'];
            $this->is_active = $row['is_active'];
            return true;
        }
        return false;
    }

    // Update product
    public function update() {
        $query = "UPDATE " . $this->table_name . "
                  SET name=:name, description=:description, hsn_sac=:hsn_sac,
                      unit=:unit, rate=:rate, tax_rate=:tax_rate, is_active=:is_active
                  WHERE id=:id";

        $stmt = $this->conn->prepare($query);

        $stmt->bindParam(':name', $this->name);
        $stmt->bindParam(':description', $this->description);
        $stmt->bindParam(':hsn_sac', $this->hsn_sac);
        $stmt->bindParam(':unit', $this->unit);
        $stmt->bindParam(':rate', $this->rate);
        $stmt->bindParam(':tax_rate', $this->tax_rate);
        $stmt->bindParam(':is_active', $this->is_active);
        $stmt->bindParam(':id', $this->id);

        return $stmt->execute();
    }

    // Search products
    public function search($keywords) {
        $query = "SELECT * FROM " . $this->table_name . " 
                  WHERE (name LIKE ? OR description LIKE ? OR hsn_sac LIKE ?) AND is_active = 1
                  ORDER BY name ASC";

        $stmt = $this->conn->prepare($query);
        $keywords = "%{$keywords}%";
        $stmt->bindParam(1, $keywords);
        $stmt->bindParam(2, $keywords);
        $stmt->bindParam(3, $keywords);
        $stmt->execute();

        return $stmt;
    }
}
?>
