<?php
session_start();
require_once 'config/database.php';
require_once 'classes/Invoice.php';

$database = new Database();
$db = $database->getConnection();

// Handle search and filters (same as invoices.php)
$search = $_GET['search'] ?? '';
$status_filter = $_GET['status'] ?? '';
$date_from = $_GET['date_from'] ?? '';
$date_to = $_GET['date_to'] ?? '';
$customer_filter = $_GET['customer_id'] ?? '';

// Build query with filters
$where_conditions = [];
$params = [];

if (!empty($search)) {
    $where_conditions[] = "(i.invoice_number LIKE ? OR c.name LIKE ?)";
    $params[] = "%$search%";
    $params[] = "%$search%";
}

if (!empty($status_filter)) {
    $where_conditions[] = "i.status = ?";
    $params[] = $status_filter;
}

if (!empty($date_from)) {
    $where_conditions[] = "i.invoice_date >= ?";
    $params[] = $date_from;
}

if (!empty($date_to)) {
    $where_conditions[] = "i.invoice_date <= ?";
    $params[] = $date_to;
}

if (!empty($customer_filter)) {
    $where_conditions[] = "i.customer_id = ?";
    $params[] = $customer_filter;
}

$where_clause = !empty($where_conditions) ? "WHERE " . implode(" AND ", $where_conditions) : "";

// Get invoices for export
$query = "SELECT i.*, c.name as customer_name, c.gstin as customer_gstin
          FROM invoices i
          LEFT JOIN customers c ON i.customer_id = c.id
          $where_clause
          ORDER BY i.created_at DESC";

$stmt = $db->prepare($query);
foreach ($params as $index => $param) {
    $stmt->bindValue($index + 1, $param);
}
$stmt->execute();

// Set headers for CSV download
header('Content-Type: text/csv');
header('Content-Disposition: attachment; filename="invoices_export_' . date('Y-m-d_H-i-s') . '.csv"');

// Create file pointer
$output = fopen('php://output', 'w');

// Add CSV headers
fputcsv($output, [
    'Invoice Number',
    'Customer Name',
    'Customer GSTIN',
    'Invoice Date',
    'Due Date',
    'Subtotal',
    'Tax Amount',
    'Total Amount',
    'Status',
    'Created Date'
]);

// Add data rows
while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    fputcsv($output, [
        $row['invoice_number'],
        $row['customer_name'],
        $row['customer_gstin'],
        date('d/m/Y', strtotime($row['invoice_date'])),
        $row['due_date'] ? date('d/m/Y', strtotime($row['due_date'])) : '',
        number_format($row['subtotal'], 2),
        number_format($row['total_tax'], 2),
        number_format($row['total_amount'], 2),
        ucfirst($row['status']),
        date('d/m/Y H:i', strtotime($row['created_at']))
    ]);
}

fclose($output);
exit;
?>
