USE invoice_system;

-- Insert default company
INSERT INTO companies (name, address, contact, email, gst_number, state, bank_name, bank_account, bank_ifsc) VALUES
('ELECTROFIX SOLUTION', 'D-171, 2nd Floor, Sector-10, Noida-201301', '8851369694', 'contact.electrofixsolution@gmail.com', '09DMFPP9986Q1ZJ', 'UTTAR PRADESH 09', 'HDFC Bank Ltd.', '50200086529101', 'HDFC0000088');

-- Insert sample customers
INSERT INTO customers (name, billing_address, shipping_address, gstin, state, contact, email) VALUES
('BHAGWATI PRODUCTS LIMITED', 
 'Entire tower Tec-1,Entire tower Tec-2, Entire Tower WTC one C, TZ-13A, IT park, sector-techzone, Greater Noida, Gautambuddha Nagar, Uttar Pradesh, 201308',
 'Entire tower Tec-1,Entire tower Tec-2, Entire Tower WTC one C, TZ-13A, IT park, sector-techzone, Greater Noida, Gautambuddha Nagar, Uttar Pradesh, 201308',
 '09AACCB1828N1ZG', 'NOIDA 09', '9876543210', 'info@bhagwatiproducts.com'),

('TECH SOLUTIONS PVT LTD', 
 'Plot No. 123, Sector 62, Noida, Uttar Pradesh, 201309',
 'Plot No. 123, Sector 62, Noida, Uttar Pradesh, 201309',
 '09ABCDE1234F1ZG', 'NOIDA 09', '9876543211', 'contact@techsolutions.com'),

('INDUSTRIAL SYSTEMS LTD', 
 'A-45, Industrial Area, Phase-1, Gurgaon, Haryana, 122001',
 'A-45, Industrial Area, Phase-1, Gurgaon, Haryana, 122001',
 '06FGHIJ5678K1ZG', 'HARYANA 06', '9876543212', 'sales@industrialsystems.com');

-- Insert sample products
INSERT INTO products (name, description, hsn_sac, unit, rate, tax_rate) VALUES
('NXT CPU Card', 'High-performance CPU card for industrial applications', '998717', 'PCS', 12500.00, 18.00),
('MPM Printer NOOD', 'Industrial grade printer with NOOD technology', '847330', 'PCS', 9800.00, 18.00),
('24V Power Supply', '24V DC power supply unit', '850440', 'PCS', 2500.00, 18.00),
('NXT Display', 'LCD display unit for NXT systems', '852580', 'PCS', 13500.00, 18.00),
('PKSP-500-24 Power Supply', '500W 24V power supply unit', '850440', 'PCS', 3500.00, 18.00),
('GPX Printer S-Axis Motor', 'Stepper motor for GPX printer S-axis', '850300', 'PCS', 5500.00, 18.00),
('Industrial Sensor', 'High precision industrial sensor', '903180', 'PCS', 1500.00, 18.00),
('Control Panel', 'Electronic control panel assembly', '853710', 'PCS', 8500.00, 18.00),
('Cable Assembly', 'Custom cable assembly for industrial use', '854420', 'MTR', 250.00, 18.00),
('Mounting Bracket', 'Heavy duty mounting bracket', '732690', 'PCS', 450.00, 18.00);

-- Insert invoice sequence for current financial year
INSERT INTO invoice_sequences (company_id, financial_year, prefix, suffix, last_number) VALUES
(1, '2025-26', '', '', 1);

-- Insert default settings
INSERT INTO settings (setting_key, setting_value, description) VALUES
('default_tax_rate', '18.00', 'Default tax rate percentage'),
('invoice_terms', 'Net 10 - Payment ten days after the invoice date', 'Default payment terms'),
('jurisdiction', 'All Disputes Are Subject to Noida Jurisdiction', 'Legal jurisdiction clause'),
('currency', 'INR', 'Default currency'),
('date_format', 'd/m/Y', 'Date display format'),
('decimal_places', '2', 'Number of decimal places for amounts');
