<?php
session_start();
require_once 'config/database.php';

$database = new Database();
$db = $database->getConnection();

// Handle form submission
if ($_POST) {
    try {
        $db->beginTransaction();
        
        foreach ($_POST as $key => $value) {
            if ($key !== 'submit') {
                $query = "INSERT INTO settings (setting_key, setting_value) VALUES (?, ?) 
                         ON DUPLICATE KEY UPDATE setting_value = VALUES(setting_value)";
                $stmt = $db->prepare($query);
                $stmt->execute([$key, $value]);
            }
        }
        
        $db->commit();
        $success_message = "Settings updated successfully!";
    } catch (Exception $e) {
        $db->rollback();
        $error_message = "Failed to update settings: " . $e->getMessage();
    }
}

// Get current settings
$settings_query = "SELECT setting_key, setting_value FROM settings";
$settings_stmt = $db->prepare($settings_query);
$settings_stmt->execute();

$settings = [];
while ($row = $settings_stmt->fetch(PDO::FETCH_ASSOC)) {
    $settings[$row['setting_key']] = $row['setting_value'];
}

// Default values
$defaults = [
    'company_name' => 'ELECTROFIX SOLUTION',
    'company_address' => 'D-171, 2nd Floor, Sector-10, Noida-201301',
    'company_contact' => '8851369694',
    'company_email' => 'contact.electrofixsolution@gmail.com',
    'company_gst' => '09DMFPP9986Q1ZJ',
    'company_state' => 'UTTAR PRADESH 09',
    'bank_name' => 'HDFC Bank Ltd.',
    'bank_account' => '50200086529101',
    'bank_ifsc' => 'HDFC0000088',
    'default_tax_rate' => '18.00',
    'invoice_terms' => 'Net 10 - Payment ten days after the invoice date',
    'jurisdiction' => 'All Disputes Are Subject to Noida Jurisdiction'
];

// Merge with current settings
foreach ($defaults as $key => $value) {
    if (!isset($settings[$key])) {
        $settings[$key] = $value;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Settings - ELECTROFIX SOLUTION</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .sidebar {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
        }
        .nav-link {
            color: rgba(255, 255, 255, 0.8);
            transition: all 0.3s ease;
        }
        .nav-link:hover, .nav-link.active {
            color: white;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 10px;
        }
        .settings-card {
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3 col-lg-2 sidebar p-0">
                <div class="p-4">
                    <h4 class="text-white mb-4">
                        <i class="fas fa-bolt"></i> ELECTROFIX
                    </h4>
                    <nav class="nav flex-column">
                        <a class="nav-link mb-2" href="dashboard.php">
                            <i class="fas fa-tachometer-alt me-2"></i> Dashboard
                        </a>
                        <a class="nav-link mb-2" href="index.php">
                            <i class="fas fa-plus me-2"></i> New Invoice
                        </a>
                        <a class="nav-link mb-2" href="invoices.php">
                            <i class="fas fa-file-invoice me-2"></i> All Invoices
                        </a>
                        <a class="nav-link mb-2" href="customers.php">
                            <i class="fas fa-users me-2"></i> Customers
                        </a>
                        <a class="nav-link mb-2" href="products.php">
                            <i class="fas fa-box me-2"></i> Products
                        </a>
                        <a class="nav-link mb-2" href="reports.php">
                            <i class="fas fa-chart-bar me-2"></i> Reports
                        </a>
                        <a class="nav-link active mb-2" href="settings.php">
                            <i class="fas fa-cog me-2"></i> Settings
                        </a>
                    </nav>
                </div>
            </div>

            <!-- Main Content -->
            <div class="col-md-9 col-lg-10">
                <div class="p-4">
                    <!-- Header -->
                    <div class="mb-4">
                        <h2>System Settings</h2>
                        <p class="text-muted">Configure your invoice system settings</p>
                    </div>

                    <!-- Alerts -->
                    <?php if (isset($success_message)): ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <?= $success_message ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    <?php endif; ?>

                    <?php if (isset($error_message)): ?>
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <?= $error_message ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    <?php endif; ?>

                    <form method="POST">
                        <!-- Company Settings -->
                        <div class="card settings-card">
                            <div class="card-header">
                                <h5><i class="fas fa-building"></i> Company Information</h5>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Company Name</label>
                                        <input type="text" class="form-control" name="company_name" 
                                               value="<?= htmlspecialchars($settings['company_name']) ?>">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">GST Number</label>
                                        <input type="text" class="form-control" name="company_gst" 
                                               value="<?= htmlspecialchars($settings['company_gst']) ?>">
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Contact Number</label>
                                        <input type="text" class="form-control" name="company_contact" 
                                               value="<?= htmlspecialchars($settings['company_contact']) ?>">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Email Address</label>
                                        <input type="email" class="form-control" name="company_email" 
                                               value="<?= htmlspecialchars($settings['company_email']) ?>">
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">State</label>
                                        <input type="text" class="form-control" name="company_state" 
                                               value="<?= htmlspecialchars($settings['company_state']) ?>">
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Company Address</label>
                                    <textarea class="form-control" name="company_address" rows="3"><?= htmlspecialchars($settings['company_address']) ?></textarea>
                                </div>
                            </div>
                        </div>

                        <!-- Bank Settings -->
                        <div class="card settings-card">
                            <div class="card-header">
                                <h5><i class="fas fa-university"></i> Bank Information</h5>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Bank Name</label>
                                        <input type="text" class="form-control" name="bank_name" 
                                               value="<?= htmlspecialchars($settings['bank_name']) ?>">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Account Number</label>
                                        <input type="text" class="form-control" name="bank_account" 
                                               value="<?= htmlspecialchars($settings['bank_account']) ?>">
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">IFSC Code</label>
                                        <input type="text" class="form-control" name="bank_ifsc" 
                                               value="<?= htmlspecialchars($settings['bank_ifsc']) ?>">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Invoice Settings -->
                        <div class="card settings-card">
                            <div class="card-header">
                                <h5><i class="fas fa-file-invoice"></i> Invoice Settings</h5>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Default Tax Rate (%)</label>
                                        <input type="number" step="0.01" class="form-control" name="default_tax_rate" 
                                               value="<?= htmlspecialchars($settings['default_tax_rate']) ?>">
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Payment Terms</label>
                                    <textarea class="form-control" name="invoice_terms" rows="2"><?= htmlspecialchars($settings['invoice_terms']) ?></textarea>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Jurisdiction Clause</label>
                                    <textarea class="form-control" name="jurisdiction" rows="2"><?= htmlspecialchars($settings['jurisdiction']) ?></textarea>
                                </div>
                            </div>
                        </div>

                        <div class="text-center">
                            <button type="submit" name="submit" class="btn btn-primary btn-lg px-5">
                                <i class="fas fa-save"></i> Save Settings
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
