<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

include_once '../config/database.php';
include_once '../classes/Customer.php';

$database = new Database();
$db = $database->getConnection();

$customer = new Customer($db);

if (isset($_GET['id'])) {
    $customer->id = $_GET['id'];
    
    if ($customer->readOne()) {
        http_response_code(200);
        echo json_encode(array(
            "success" => true,
            "customer" => array(
                "id" => $customer->id,
                "name" => $customer->name,
                "billing_address" => $customer->billing_address,
                "shipping_address" => $customer->shipping_address,
                "gstin" => $customer->gstin,
                "state" => $customer->state,
                "contact" => $customer->contact,
                "email" => $customer->email
            )
        ));
    } else {
        http_response_code(404);
        echo json_encode(array(
            "success" => false,
            "message" => "Customer not found."
        ));
    }
} else {
    http_response_code(400);
    echo json_encode(array(
        "success" => false,
        "message" => "Customer ID is required."
    ));
}
?>
