<?php
require_once 'config/database.php';

class InvoiceItem {
    private $conn;
    private $table_name = "invoice_items";

    public $id;
    public $invoice_id;
    public $product_id;
    public $description;
    public $hsn_sac;
    public $quantity;
    public $unit;
    public $rate;
    public $amount;

    public function __construct($db) {
        $this->conn = $db;
    }

    // Create invoice item
    public function create() {
        $query = "INSERT INTO " . $this->table_name . " 
                  SET invoice_id=:invoice_id, product_id=:product_id, description=:description,
                      hsn_sac=:hsn_sac, quantity=:quantity, unit=:unit, rate=:rate, amount=:amount";

        $stmt = $this->conn->prepare($query);

        // Sanitize
        $this->description = htmlspecialchars(strip_tags($this->description));
        $this->hsn_sac = htmlspecialchars(strip_tags($this->hsn_sac));
        $this->unit = htmlspecialchars(strip_tags($this->unit));

        // Bind values
        $stmt->bindParam(":invoice_id", $this->invoice_id);
        $stmt->bindParam(":product_id", $this->product_id);
        $stmt->bindParam(":description", $this->description);
        $stmt->bindParam(":hsn_sac", $this->hsn_sac);
        $stmt->bindParam(":quantity", $this->quantity);
        $stmt->bindParam(":unit", $this->unit);
        $stmt->bindParam(":rate", $this->rate);
        $stmt->bindParam(":amount", $this->amount);

        return $stmt->execute();
    }

    // Read items by invoice ID
    public function readByInvoiceId($invoice_id) {
        $query = "SELECT * FROM " . $this->table_name . " WHERE invoice_id = ? ORDER BY id ASC";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $invoice_id);
        $stmt->execute();
        return $stmt;
    }

    // Delete items by invoice ID
    public function deleteByInvoiceId($invoice_id) {
        $query = "DELETE FROM " . $this->table_name . " WHERE invoice_id = ?";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $invoice_id);
        return $stmt->execute();
    }

    // Update item
    public function update() {
        $query = "UPDATE " . $this->table_name . "
                  SET product_id=:product_id, description=:description, hsn_sac=:hsn_sac,
                      quantity=:quantity, unit=:unit, rate=:rate, amount=:amount
                  WHERE id=:id";

        $stmt = $this->conn->prepare($query);

        $stmt->bindParam(':product_id', $this->product_id);
        $stmt->bindParam(':description', $this->description);
        $stmt->bindParam(':hsn_sac', $this->hsn_sac);
        $stmt->bindParam(':quantity', $this->quantity);
        $stmt->bindParam(':unit', $this->unit);
        $stmt->bindParam(':rate', $this->rate);
        $stmt->bindParam(':amount', $this->amount);
        $stmt->bindParam(':id', $this->id);

        return $stmt->execute();
    }
}
?>
