<?php
require_once 'config/database.php';

$database = new Database();
$db = $database->getConnection();

if (!$db) {
    die("Database connection failed. Please check your configuration in config/database.php");
}

$setup_complete = false;
$error_message = '';

try {
    // Read and execute the setup SQL
    $sql_file = 'scripts/setup_database.sql';
    if (file_exists($sql_file)) {
        $sql = file_get_contents($sql_file);
        
        // Split SQL into individual statements
        $statements = array_filter(array_map('trim', explode(';', $sql)));
        
        foreach ($statements as $statement) {
            if (!empty($statement)) {
                $db->exec($statement);
            }
        }
        
        $setup_complete = true;
    } else {
        $error_message = "Setup SQL file not found: $sql_file";
    }
    
} catch (Exception $e) {
    $error_message = "Setup failed: " . $e->getMessage();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Database Setup - ELECTROFIX SOLUTION</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header text-center">
                        <h3><i class="fas fa-bolt"></i> ELECTROFIX SOLUTION</h3>
                        <h5>Database Setup</h5>
                    </div>
                    <div class="card-body">
                        <?php if ($setup_complete): ?>
                            <div class="alert alert-success">
                                <i class="fas fa-check-circle"></i> Database setup completed successfully!
                            </div>
                            <div class="text-center">
                                <a href="dashboard.php" class="btn btn-primary">
                                    <i class="fas fa-tachometer-alt"></i> Go to Dashboard
                                </a>
                                <a href="index.php" class="btn btn-success">
                                    <i class="fas fa-plus"></i> Create Invoice
                                </a>
                            </div>
                        <?php elseif ($error_message): ?>
                            <div class="alert alert-danger">
                                <i class="fas fa-exclamation-triangle"></i> <?= $error_message ?>
                            </div>
                            <div class="text-center">
                                <button onclick="location.reload()" class="btn btn-warning">
                                    <i class="fas fa-redo"></i> Retry Setup
                                </button>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
