<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once '../config/database.php';

$database = new Database();
$db = $database->getConnection();

// Get posted data
$data = json_decode(file_get_contents("php://input"));

if (!empty($data->invoice_ids)) {
    
    try {
        $db->beginTransaction();
        
        // Prepare delete query for invoice items first (due to foreign key constraint)
        $placeholders = str_repeat('?,', count($data->invoice_ids) - 1) . '?';
        
        // Delete invoice items
        $items_query = "DELETE FROM invoice_items WHERE invoice_id IN ($placeholders)";
        $items_stmt = $db->prepare($items_query);
        $items_stmt->execute($data->invoice_ids);
        
        // Delete invoices
        $invoice_query = "DELETE FROM invoices WHERE id IN ($placeholders)";
        $invoice_stmt = $db->prepare($invoice_query);
        $invoice_stmt->execute($data->invoice_ids);
        
        $affected_rows = $invoice_stmt->rowCount();
        
        $db->commit();
        
        http_response_code(200);
        echo json_encode(array(
            "success" => true,
            "message" => "Successfully deleted $affected_rows invoice(s)",
            "affected_rows" => $affected_rows
        ));
        
    } catch (Exception $e) {
        $db->rollback();
        http_response_code(503);
        echo json_encode(array(
            "success" => false,
            "message" => "Error deleting invoices: " . $e->getMessage()
        ));
    }
    
} else {
    http_response_code(400);
    echo json_encode(array(
        "success" => false,
        "message" => "Invoice IDs are required"
    ));
}
?>
